<?php
// Telegram Bot API token
$bot_token = '7815971981:AAERiIsG89XKC2zRlyxgtAjMUiIkOMNYu_c';
$api_url = "https://api.telegram.org/bot$bot_token/";

// Path to FFmpeg
$ffmpeg_path = '/usr/bin/ffmpeg';

// Log file path
$log_file = 'bot_error_log.txt';

// Queue directory
$queue_dir = 'video_queue/';

// Maximum file size (100MB)
$max_file_size = 100 * 1024 * 1024;

// Create queue directory if not exists
if (!file_exists($queue_dir)) {
    mkdir($queue_dir, 0777, true);
}

// Enhanced error logging function
function logError($message, $critical = false) {
    global $log_file;
    $timestamp = date('Y-m-d H:i:s');
    $log_message = "[$timestamp] " . ($critical ? "[CRITICAL] " : "") . "$message\n";
    file_put_contents($log_file, $log_message, FILE_APPEND);
}

// Function to get file URL from Telegram Bot API
function getFileUrl($file_id, $bot_token) {
    $api_url = "https://api.telegram.org/bot$bot_token/getFile?file_id=$file_id";
    $response = @file_get_contents($api_url);
    
    if ($response === false) {
        logError("Failed to get file URL", true);
        return false;
    }
    
    $data = json_decode($response, true);
    
    if (!isset($data['result']['file_path'])) {
        logError("No file path in response", true);
        return false;
    }
    
    return "https://api.telegram.org/file/bot$bot_token/" . $data['result']['file_path'];
}

// Function to send message to Telegram chat
function sendMessage($chat_id, $text) {
    global $api_url;
    $url = $api_url . "sendMessage?chat_id=$chat_id&text=" . urlencode($text);
    @file_get_contents($url);
}

// Function to send video to Telegram chat
function sendVideo($chat_id, $video_path,$caption='') {
    global $api_url, $bot_token;
    
    $file = new CURLFile($video_path);
    $post_data = [
        'chat_id' => $chat_id,
        'video' => $file,
        'caption'=>$caption
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url . 'sendVideo');
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    
    $result = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        logError("Video send error: $error", true);
        return false;
    }
    
    return true;
}

// Function to validate video file
function validateVideoFile($file_path) {
    global $max_file_size, $ffmpeg_path;

    // Check file size
    if (filesize($file_path) > $max_file_size) {
        logError("File too large: " . filesize($file_path) . " bytes", true);
        return false;
    }

    return true;
}

// Simplified video processing function
function processVideoQueue() {
    echo "we are here 1";
    global $queue_dir, $ffmpeg_path;

    // Get all queued video files
    $queue_files = glob($queue_dir . '*.json');
    
    foreach ($queue_files as $queue_file) {
        // Read queue metadata
        $queue_data = json_decode(file_get_contents($queue_file), true);
        
        $input_video = $queue_data['input_video'];
        $output_video = $queue_data['output_video'];
        $webm_overlay = $queue_data['webm_overlay'];
        $chat_id = $queue_data['chat_id'];
        $caption=$queue_data['caption'];

        // Limit system resources
        $nice_level = 10; // Lower priority
        $max_load = 0.7; // Max system load before skipping

        // Check system load
        $current_load = sys_getloadavg()[0];
        
        // if ($current_load > $max_load) {
        //         echo "we are here 2";

        //     logError("System load too high: $current_load. Skipping processing.");
        //     continue;
        // }

        // Get video dimensions
     $ffprobe_path = '/usr/bin/ffprobe'; // مسیر ffprobe را مشخص کنید


// دستور برای استخراج اطلاعات ویدیو
$cmd = "$ffprobe_path -v error -select_streams v:0 -show_entries stream=width,height -show_entries format=size -of json $input_video";


// اجرای دستور و گرفتن خروجی
exec($cmd, $output, $return_var);
echo json_encode($output);
echo " \n\n\n\n herehere";
// بررسی خطا
if ($return_var !== 0) {
    echo "Error occurred while processing the video";
    return;
}


// تبدیل خروجی به آرایه PHP

$video_info = json_decode(implode("\n", $output), true);
echo "has been set";

$data = $video_info;

// استخراج حجم فایل به بایت
$file_size = isset($data['format']['size']) ? $data['format']['size'] : 0;

// تبدیل ۱۰ مگابایت به بایت (۱۰ * 1024 * 1024)
$ten_mb = 12 * 1024 * 1024;
echo "has been set";

// بررسی اینکه حجم فایل کمتر از ۱۰ مگابایت است یا نه
if ($file_size < $ten_mb) {
$crf=28;
echo "has been set";
    
} else {

    $crf=38;
}
// بررسی وجود ابعاد
if (isset($video_info['streams'][0]['width']) && isset($video_info['streams'][0]['height'])) {
    $video_width = $video_info['streams'][0]['width'];
    $video_height = $video_info['streams'][0]['height'];
    echo "Width: $video_width, Height: $video_height";
} else {
    echo "Failed to extract video dimensions.";
    return;
}
    echo "we are here 4";

        // Calculate logo size and position
     // Calculate logo size
 if ($video_width >= $video_height) {
    $logo_width = round($video_width * 0.15);
    $logo_height = -1; // Maintain aspect ratio

    $logo_x = round($video_width * 0.01);
    $logo_y = 0;

    $hsh_width = round($video_width * 0.18);
    $hsh_height = -1; // حفظ نسبت تصویر
    $hsh_x = round(($video_width - $hsh_width) / 2);
    $hsh_y = round($video_height - (0.12 * $video_height) - $hsh_height);
} else {
    $logo_width = round($video_height * 0.18);
    $logo_height = -1; // Maintain aspect ratio

    $logo_x = round($video_height * 0.01);
    $logo_y = 0;

    $hsh_width = round($video_height * 0.2);
    $hsh_height = -1; // حفظ نسبت تصویر
    $hsh_x = round(($video_width - $hsh_width) / 2);
    $hsh_y = round($video_height - (0.1 * $video_height) - $hsh_height);
}

// Paths for intermediate and final files
$resized_logo = "resized_logo.png";
$resized_hsh = "resized_hsh.png";

// Step 1: Resize the first logo
$resize_command = "$ffmpeg_path -y -i $webm_overlay -vf scale=$logo_width:$logo_height -c:v png -pix_fmt rgba $resized_logo 2>&1";
exec($resize_command, $output, $return_var);
if ($return_var !== 0) {
    die("Error resizing logo: " . implode("\n", $output));
}

// Step 2: Resize the second logo (hsh.png)
list($hsh_original_width, $hsh_original_height) = getimagesize("hsh.png");
$hsh_height = round(($hsh_width / $hsh_original_width) * $hsh_original_height); // حفظ نسبت تصویر
$resize_hsh_command = "$ffmpeg_path -y -i hsh.png -vf scale=$hsh_width:$hsh_height -c:v png -pix_fmt rgba $resized_hsh 2>&1";
exec($resize_hsh_command, $output, $return_var);
if ($return_var !== 0) {
    die("Error resizing hsh.png: " . implode("\n", $output));
}

// Step 3: Apply both overlays
// $overlay_command = "$ffmpeg_path -i $input_video -i $resized_logo -i $resized_hsh \
// -filter_complex \"[0:v][1:v]overlay=$logo_x:$logo_y:format=auto[out1]; \
// [out1][2:v]overlay=$hsh_x:$hsh_y:format=auto[out2]\" \
// -map \"[out2]\" -map 0:a \
// -c:v libx264 -preset medium -crf $crf -pix_fmt yuv420p \
// -profile:v baseline -movflags +faststart \
// -codec:a aac -b:a 128k \
// $output_video 2>&1";

$overlay_command = "/usr/bin/taskset -c 9,10,11,12,13 $ffmpeg_path -i $input_video -i $resized_logo -i $resized_hsh \
-filter_complex \"[0:v][1:v]overlay=$logo_x:$logo_y:format=auto[out1]; \
[out1][2:v]overlay=$hsh_x:$hsh_y:format=auto[out2]\" \
-map \"[out2]\" -map 0:a? \
-c:v libx264 -preset medium -crf $crf -pix_fmt yuv420p \
-profile:v baseline -movflags +faststart \
-codec:a aac -b:a 128k \
$output_video 2>&1";
echo shell_exec($overlay_command);

// Cleanup
unlink($resized_logo);
unlink($resized_hsh);

        
        // Execute with timeout
        $descriptors = [
            0 => ['pipe', 'r'],  // stdin
            1 => ['pipe', 'w'],  // stdout
            2 => ['pipe', 'w']   // stderr
        ];
        
        $process = proc_open($command, $descriptors, $pipes, null, null);
        
        if (is_resource($process)) {
            $start_time = time();
            $timeout = 200; // 5 minute timeout
            
            while (proc_get_status($process)['running']) {
                if (time() - $start_time > $timeout) {
                    proc_terminate($process);
                    logError("Video processing timeout", true);
                    break;
                }
                sleep(1);
            }
            
            proc_close($process);
        }

        // Check processing result
      // بررسی خروجی ویدیو با اطلاعات دقیق‌تر
if (file_exists($output_video)) {
    $output_size = filesize($output_video);
    logError("Output video exists. Size: $output_size bytes");

    // اگر سایز ویدیو بزرگتر از 0 باشد
    if ($output_size > 0) {
        // تلاش برای ارسال ویدیو با اطلاعات دقیق‌تر
        $send_result = sendVideo($chat_id, $output_video ,$caption);
        
        if ($send_result) {
            // پاک کردن فایل‌ها در صورت ارسال موفق
            unlink($input_video);
            unlink($output_video);
            logError("Video sent and files cleaned successfully");
        } else {
            // اگر ارسال ویدیو شکست خورد
            sendMessage($chat_id, "ارسال ویدیو با مشکل مواجه شد.");
            logError("Video sending failed", true);
        }
    } else {
        // اگر سایز ویدیو صفر باشد
        sendMessage($chat_id, "ویدیو پردازش نشده است.");
        logError("Output video size is zero", true);
    }
} else {
    // اگر فایل خروجی اصلاً وجود نداشته باشد
    sendMessage($chat_id, "فایل ویدیو ایجاد نشده است.");
    logError("Output video file does not exist", true);
}
        // Remove queue file
        unlink($queue_file);
    }
}

// Webhook handler
function handleWebhook() {
    global $queue_dir, $bot_token;

    $update = json_decode(file_get_contents("php://input"), TRUE);
$chat_ids = [
    1394040489,
    6318040269,
    515701089,
    291282130,
    5264512719,
    44684269,
    1381907095,
    6780200816,
	271568447,
	67009203,
	85136394,
	820865369,
	5529728890,
	1792278798,
	5480649697,
	86209863,
	69458413,
	381572546,
	6561961795
];
    if (isset($update['message']['video'])) {
        $caption=$update['message']['caption'];
        $chat_id = $update['message']['chat']['id'];
        if (in_array($chat_id, $chat_ids)) {

        $video_id = $update['message']['video']['file_id'];
        $webm_overlay = 'hamshahri.png';

        // Get file URL
        $file_url = getFileUrl($video_id, $bot_token);
        if (!$file_url) {
            sendMessage($chat_id, "خطا در دریافت آدرس فایل.");
            return;
        }

        // Download video
        $input_video = 'downloaded_video_' . uniqid() . '.mp4';
        $output_video = 'output_video_' . uniqid() . '.mp4';
        
        $file_contents = @file_get_contents($file_url);
        
        if ($file_contents === false) {
            sendMessage($chat_id, "خطا در دانلود فایل.");
            return;
        }
        
        file_put_contents($input_video, $file_contents);

        // Validate video
        if (!validateVideoFile($input_video)) {
            unlink($input_video);
            sendMessage($chat_id, "فایل ویدیو نامعتبر است.");
            return;
        }

        // Verify webm overlay exists
        if (!file_exists($webm_overlay)) {
            unlink($input_video);
            sendMessage($chat_id, "فایل لوگو یافت نشد.");
            return;
        }

        // Create queue file
        $queue_data = [
            'input_video' => $input_video,
            'output_video' => $output_video,
            'webm_overlay' => $webm_overlay,
            'chat_id' => $chat_id,
            'caption'=>$caption,
            'timestamp' => time()
        ];

        // Save queue file
        $queue_file = $queue_dir . 'queue_' . uniqid() . '.json';
        file_put_contents($queue_file, json_encode($queue_data));

        sendMessage($chat_id, "ویدیو در صف پردازش قرار گرفت.");
    }
    else{
        return;
    }
    }
}

// Run webhook or processing
if (php_sapi_name() === 'cli'||(isset($_GET['process']) && $_GET['process'] == 'queue')) {
    // CLI mode: process queue
    processVideoQueue();
} else {
    // Webhook mode: handle incoming request
    handleWebhook();
}
?>